/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public abstract class ActionTextField
extends JTextField {
    Color defaultColor;
    Color modifiedColor;
    boolean valueModified;
    String originalValue;

    public void notifyRestoreOriginalValue() {
        if (this.valueModified) {
            this.valueModified = false;
            this.setText(this.originalValue);
            this.originalValue = null;
            this.setBackground(this.defaultColor);
        }
    }

    public void notifyValueModified() {
        if (!this.valueModified) {
            this.valueModified = true;
            this.originalValue = this.getText();
            this.setBackground(this.modifiedColor);
        }
    }

    public void notifyDoneModifying() {
        if (this.valueModified) {
            this.valueModified = false;
            this.originalValue = null;
            this.setBackground(this.defaultColor);
            this.doSaveEvent();
        }
    }

    public abstract void doSaveEvent();

    public ActionTextField(String text, int columns) {
        super(text, columns);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.defaultColor = this.getBackground();
        this.modifiedColor = new Color(128, 128, 255);
        this.valueModified = false;
        this.addFocusListener(new StoringFocusListener(this));
        this.addKeyListener(new NotifyingKeyListener(this));
    }

    private class NotifyingKeyListener
    implements KeyListener {
        final ActionTextField textField;

        public NotifyingKeyListener(ActionTextField textField) {
            this.textField = textField;
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyChar() == '\n') {
                this.textField.notifyDoneModifying();
            } else if (arg0.getKeyChar() == '\u001b') {
                this.textField.notifyRestoreOriginalValue();
            } else {
                this.textField.notifyValueModified();
            }
        }
    }

    private class StoringFocusListener
    implements FocusListener {
        final ActionTextField textField;

        public StoringFocusListener(ActionTextField textField) {
            this.textField = textField;
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.textField.notifyDoneModifying();
        }
    }
}

